<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'ایجاد کاربر جدید';
$db = Database::getInstance();
$session = Session::getInstance();

$errors = [];
$formData = [];

if (isPost()) {
    // دریافت داده‌های فرم
    $formData = [
        'email' => sanitize(post('email')),
        'password' => post('password'),
        'password_confirm' => post('password_confirm'),
        'username' => sanitize(post('username')),
        'full_name' => sanitize(post('full_name')),
        'gender' => post('gender'),
        'age' => (int)post('age', 0),
        'birth_date' => post('birth_date'),
        'language' => post('language', 'fa'),
        'calendar_type' => post('calendar_type', 'gregorian'),
        'plan_type' => post('plan_type'),
        'status' => post('status', 'active')
    ];

    // اعتبارسنجی
    if (empty($formData['email'])) {
        $errors[] = 'ایمیل الزامی است.';
    } elseif (!isValidEmail($formData['email'])) {
        $errors[] = 'فرمت ایمیل نامعتبر است.';
    } else {
        // بررسی تکراری نبودن ایمیل
        $existingUser = $db->fetchOne("SELECT id FROM users WHERE email = ?", [$formData['email']]);
        if ($existingUser) {
            $errors[] = 'این ایمیل قبلاً ثبت شده است.';
        }
    }

    if (empty($formData['password'])) {
        $errors[] = 'رمز عبور الزامی است.';
    } elseif (strlen($formData['password']) < 8) {
        $errors[] = 'رمز عبور باید حداقل 8 کاراکتر باشد.';
    } elseif ($formData['password'] !== $formData['password_confirm']) {
        $errors[] = 'تکرار رمز عبور مطابقت ندارد.';
    }

    if ($formData['username']) {
        // بررسی تکراری نبودن نام کاربری
        $existingUsername = $db->fetchOne("SELECT id FROM users WHERE username = ?", [$formData['username']]);
        if ($existingUsername) {
            $errors[] = 'این نام کاربری قبلاً استفاده شده است.';
        }
    }

    if (empty($errors)) {
        try {
            $db->beginTransaction();

            // ایجاد کاربر
            $userData = [
                'email' => $formData['email'],
                'password_hash' => hashPassword($formData['password']),
                'username' => $formData['username'] ?: null,
                'full_name' => $formData['full_name'] ?: null,
                'gender' => $formData['gender'] ?: null,
                'age' => $formData['age'] ?: null,
                'birth_date' => $formData['birth_date'] ?: null,
                'language' => $formData['language'],
                'calendar_type' => $formData['calendar_type'],
                'status' => $formData['status'],
                'email_verified' => 1, // از طرف ادمین ایجاد شده
                'created_at' => date('Y-m-d H:i:s')
            ];

            $userId = $db->insert('users', $userData);

            // ایجاد اشتراک اگر پلن انتخاب شده
            if ($formData['plan_type']) {
                $subscriptionData = [
                    'user_id' => $userId,
                    'plan_type' => $formData['plan_type'],
                    'status' => 'active',
                    'payment_method' => 'admin_grant',
                    'current_period_start' => date('Y-m-d H:i:s'),
                    'current_period_end' => date('Y-m-d H:i:s', strtotime('+1 year')),
                    'created_at' => date('Y-m-d H:i:s')
                ];

                $db->insert('subscriptions', $subscriptionData);
            }

            $db->commit();

            $session->setSuccess('کاربر با موفقیت ایجاد شد.');
            redirect('user_detail.php?id=' . $userId);

        } catch (Exception $e) {
            $db->rollback();
            $errors[] = 'خطا در ایجاد کاربر: ' . $e->getMessage();
            logError('Error creating user: ' . $e->getMessage());
        }
    }
}

include 'php/includes/header.php';
?>


<div class="row clearfix">
    <div class="col-lg-8 col-md-10 col-sm-12 col-xs-12" style="margin: 0 auto; float: none;">
        <div class="card">
            <div class="header">
                <h2>اطلاعات کاربر</h2>
            </div>
            <div class="body">
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <strong>خطاها:</strong>
                        <ul class="m-b-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?php echo h($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">

                    <h4 class="m-t-0">اطلاعات اولیه</h4>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>ایمیل <span class="text-danger">*</span></label>
                                <div class="form-line">
                                    <input type="email" name="email" class="form-control" required
                                           value="<?php echo h($formData['email'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نام کاربری</label>
                                <div class="form-line">
                                    <input type="text" name="username" class="form-control"
                                           value="<?php echo h($formData['username'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>رمز عبور <span class="text-danger">*</span></label>
                                <div class="form-line">
                                    <input type="password" name="password" class="form-control" required
                                           minlength="8" placeholder="حداقل 8 کاراکتر">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تکرار رمز عبور <span class="text-danger">*</span></label>
                                <div class="form-line">
                                    <input type="password" name="password_confirm" class="form-control" required
                                           minlength="8">
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr>
                    <h4>اطلاعات شخصی</h4>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>نام کامل</label>
                                <div class="form-line">
                                    <input type="text" name="full_name" class="form-control"
                                           value="<?php echo h($formData['full_name'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>جنسیت</label>
                                <select name="gender" class="form-control">
                                    <option value="">انتخاب کنید</option>
                                    <option value="male" <?php echo ($formData['gender'] ?? '') === 'male' ? 'selected' : ''; ?>>مرد</option>
                                    <option value="female" <?php echo ($formData['gender'] ?? '') === 'female' ? 'selected' : ''; ?>>زن</option>
                                    <option value="other" <?php echo ($formData['gender'] ?? '') === 'other' ? 'selected' : ''; ?>>سایر</option>
                                    <option value="prefer_not_to_say" <?php echo ($formData['gender'] ?? '') === 'prefer_not_to_say' ? 'selected' : ''; ?>>ترجیح می‌دهم نگویم</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>سن</label>
                                <div class="form-line">
                                    <input type="number" name="age" class="form-control" min="1" max="150"
                                           value="<?php echo h($formData['age'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>تاریخ تولد</label>
                                <div class="form-line">
                                    <input type="date" name="birth_date" class="form-control"
                                           value="<?php echo h($formData['birth_date'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr>
                    <h4>تنظیمات</h4>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>زبان</label>
                                <select name="language" class="form-control">
                                    <option value="fa" <?php echo ($formData['language'] ?? 'fa') === 'fa' ? 'selected' : ''; ?>>فارسی</option>
                                    <option value="en" <?php echo ($formData['language'] ?? 'fa') === 'en' ? 'selected' : ''; ?>>English</option>
                                    <option value="de" <?php echo ($formData['language'] ?? 'fa') === 'de' ? 'selected' : ''; ?>>Deutsch</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>نوع تقویم</label>
                                <select name="calendar_type" class="form-control">
                                    <option value="gregorian" <?php echo ($formData['calendar_type'] ?? 'gregorian') === 'gregorian' ? 'selected' : ''; ?>>میلادی</option>
                                    <option value="jalali" <?php echo ($formData['calendar_type'] ?? 'gregorian') === 'jalali' ? 'selected' : ''; ?>>شمسی</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>وضعیت حساب</label>
                                <select name="status" class="form-control">
                                    <option value="active" <?php echo ($formData['status'] ?? 'active') === 'active' ? 'selected' : ''; ?>>فعال</option>
                                    <option value="suspended" <?php echo ($formData['status'] ?? 'active') === 'suspended' ? 'selected' : ''; ?>>معلق</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <hr>
                    <h4>اشتراک</h4>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>پلن اشتراک</label>
                                <select name="plan_type" class="form-control">
                                    <option value="">بدون اشتراک</option>
                                    <option value="free_trial" <?php echo ($formData['plan_type'] ?? '') === 'free_trial' ? 'selected' : ''; ?>>آزمایشی رایگان</option>
                                    <option value="freemium" <?php echo ($formData['plan_type'] ?? '') === 'freemium' ? 'selected' : ''; ?>>فریمیوم</option>
                                    <option value="plus" <?php echo ($formData['plan_type'] ?? '') === 'plus' ? 'selected' : ''; ?>>پلاس</option>
                                    <option value="premium" <?php echo ($formData['plan_type'] ?? '') === 'premium' ? 'selected' : ''; ?>>پریمیوم</option>
                                </select>
                                <small class="text-muted">اگر پلن انتخاب شود، اشتراک به مدت 1 سال فعال می‌شود.</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn-action btn-save waves-effect">
                                <i class="material-icons">save</i>
                                <span>ایجاد کاربر</span>
                            </button>

                            <a href="users.php" class="btn-action waves-effect">
                                <i class="material-icons">cancel</i>
                                <span>انصراف</span>
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
