<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مسدود کردن کاربر';
$db = Database::getInstance();
$session = Session::getInstance();
$auth = Auth::getInstance();

$userId = (int)get('id', 0);

if (!$userId) {
    redirect('users.php');
}

// دریافت اطلاعات کاربر
$user = $db->fetchOne("SELECT * FROM users WHERE id = ?", [$userId]);

if (!$user) {
    redirect('users.php');
}

// بررسی اینکه کاربر از قبل مسدود نباشد
if ($user['status'] === 'banned') {
    $session->setWarning('این کاربر از قبل مسدود است.');
    redirect('user_detail.php?id=' . $userId);
}

$errors = [];

if (isPost()) {
    $reason = sanitize(post('reason'));
    $message = sanitize(post('message'));

    // اعتبارسنجی
    if (empty($reason)) {
        $errors[] = 'دلیل مسدودسازی الزامی است.';
    }

    if (empty($errors)) {
        try {
            $adminId = $auth->getAdminId();

            // استفاده از Stored Procedure
            $stmt = $db->getPdo()->prepare("CALL sp_ban_user(?, ?, ?, ?)");
            $stmt->execute([$userId, $reason, $message, $adminId]);

            $session->setSuccess('کاربر با موفقیت مسدود شد.');
            redirect('user_detail.php?id=' . $userId);

        } catch (Exception $e) {
            $errors[] = 'خطا در مسدود کردن کاربر: ' . $e->getMessage();
            logError('Error banning user: ' . $e->getMessage());
        }
    }
}

include 'php/includes/header.php';
?>


<div class="row clearfix">
    <div class="col-lg-6 col-md-8 col-sm-12 col-xs-12" style="margin: 0 auto; float: none;">
        <div class="card">
            <div class="header bg-red">
                <h2 class="text-white">
                    <i class="material-icons">block</i>
                    مسدود کردن کاربر
                </h2>
            </div>
            <div class="body">
                <!-- اطلاعات کاربر -->
                <div class="alert alert-warning">
                    <strong>توجه:</strong> شما در حال مسدود کردن کاربر زیر هستید:
                    <hr>
                    <p class="m-b-0">
                        <strong>ID:</strong> <?php echo $user['id']; ?><br>
                        <strong>ایمیل:</strong> <?php echo h($user['email']); ?><br>
                        <strong>نام:</strong> <?php echo h($user['full_name'] ?? 'نامشخص'); ?><br>
                        <strong>تاریخ عضویت:</strong> <?php echo formatDate($user['created_at']); ?>
                    </p>
                </div>

                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <strong>خطاها:</strong>
                        <ul class="m-b-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?php echo h($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" action="" id="banForm" onsubmit="return confirmBan();">
                    <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">

                    <div class="form-group">
                        <label>دلیل مسدودسازی <span class="text-danger">*</span></label>
                        <select name="reason" class="form-control" required>
                            <option value="">انتخاب کنید...</option>
                            <option value="spam">اسپم / ارسال محتوای ناخواسته</option>
                            <option value="abuse">سوءاستفاده از سیستم</option>
                            <option value="violation">نقض قوانین و مقررات</option>
                            <option value="fraud">تقلب / فعالیت غیرقانونی</option>
                            <option value="multiple_accounts">ایجاد چندین حساب کاربری</option>
                            <option value="payment_issue">مشکل پرداخت / کلاهبرداری</option>
                            <option value="harassment">آزار و اذیت کاربران دیگر</option>
                            <option value="inappropriate_content">محتوای نامناسب</option>
                            <option value="security_threat">تهدید امنیتی</option>
                            <option value="user_request">درخواست کاربر</option>
                            <option value="other">سایر موارد</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>پیام برای کاربر (اختیاری)</label>
                        <textarea name="message" class="form-control" rows="5"
                                  placeholder="این پیام برای کاربر نمایش داده می‌شود و علت مسدودی را توضیح می‌دهد..."><?php echo h(post('message', '')); ?></textarea>
                        <small class="text-muted">
                            این پیام هنگام تلاش کاربر برای ورود به سیستم نمایش داده می‌شود.
                        </small>
                    </div>

                    <div class="alert alert-danger">
                        <h4><i class="material-icons">warning</i> هشدار</h4>
                        <p>پس از مسدود شدن:</p>
                        <ul>
                            <li>کاربر نمی‌تواند وارد سیستم شود</li>
                            <li>دسترسی به تمام امکانات قطع می‌شود</li>
                            <li>اشتراک‌های فعال به حالت تعلیق درمی‌آیند</li>
                            <li>این عملیات در لاگ سیستم ثبت می‌شود</li>
                        </ul>
                        <p class="m-b-0">آیا از مسدود کردن این کاربر اطمینان دارید؟</p>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn-action waves-effect" style="color: #f44336 !important; border-color: #f44336 !important;">
                                <i class="material-icons" style="color: #f44336 !important;">block</i>
                                <span>بله، کاربر را مسدود کن</span>
                            </button>

                            <a href="user_detail.php?id=<?php echo $userId; ?>" class="btn-action waves-effect">
                                <i class="material-icons">cancel</i>
                                <span>انصراف</span>
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmBan() {
    const reason = document.querySelector('select[name="reason"]').value;
    if (!reason) {
        alert('لطفاً دلیل مسدودسازی را انتخاب کنید.');
        return false;
    }

    return confirm('آیا مطمئن هستید که می‌خواهید این کاربر را مسدود کنید؟\n\nاین عملیات در لاگ سیستم ثبت خواهد شد.');
}
</script>

<?php include 'php/includes/footer.php'; ?>
