<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'گزارش‌ها و آمار';
$db = Database::getInstance();

// بازه زمانی (پیش‌فرض: 30 روز گذشته)
$dateFrom = get('date_from', date('Y-m-d', strtotime('-30 days')));
$dateTo = get('date_to', date('Y-m-d'));

// آمار کلی کاربران
$userStats = [
    'total' => $db->count('users'),
    'active' => $db->count('users', 'status = ?', ['active']),
    'suspended' => $db->count('users', 'status = ?', ['suspended']),
    'banned' => $db->count('users', 'status = ?', ['banned']),
    'new_this_month' => $db->fetchOne("
        SELECT COUNT(*) as count
        FROM users
        WHERE DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)
    ")['count'] ?? 0
];

// آمار اشتراک‌ها
$subscriptionStats = $db->fetchAll("
    SELECT
        plan_type,
        COUNT(*) as count,
        SUM(CASE WHEN status = 'active' THEN 1 ELSE 0 END) as active_count
    FROM subscriptions
    GROUP BY plan_type
    ORDER BY
        CASE plan_type
            WHEN 'premium' THEN 1
            WHEN 'plus' THEN 2
            WHEN 'freemium' THEN 3
            WHEN 'free_trial' THEN 4
        END
");

// آمار چرخه‌ها
$cycleStats = [
    'total' => $db->count('cycles'),
    'this_month' => $db->fetchOne("
        SELECT COUNT(*) as count
        FROM cycles
        WHERE DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)
    ")['count'] ?? 0,
    'today' => $db->fetchOne("
        SELECT COUNT(*) as count
        FROM cycles
        WHERE DATE(created_at) = CURDATE()
    ")['count'] ?? 0,
    'avg_per_user' => $db->fetchOne("
        SELECT AVG(total_cycles) as avg
        FROM users
        WHERE total_cycles > 0
    ")['avg'] ?? 0
];

// چرخه‌ها به تفکیک احساس
$cyclesByFeeling = $db->fetchAll("
    SELECT
        CASE
            WHEN feeling LIKE '%reactive%' OR feeling LIKE '%واکنشی%' THEN 'reactive'
            WHEN feeling LIKE '%contract%' OR feeling LIKE '%منقبض%' THEN 'contracting'
            WHEN feeling LIKE '%growth%' OR feeling LIKE '%رشد%' THEN 'growth'
            WHEN feeling LIKE '%ultimate%' OR feeling LIKE '%نهایی%' THEN 'ultimate'
            ELSE 'other'
        END as feeling_type,
        COUNT(*) as count
    FROM cycles
    GROUP BY feeling_type
");

// سطح آگاهی به تفکیک بازه
$awarenessLevels = $db->fetchAll("
    SELECT
        CASE
            WHEN awareness_level >= 0 AND awareness_level < 10 THEN '0-10%'
            WHEN awareness_level >= 10 AND awareness_level < 20 THEN '10-20%'
            WHEN awareness_level >= 20 AND awareness_level < 30 THEN '20-30%'
            WHEN awareness_level >= 30 AND awareness_level < 40 THEN '30-40%'
            WHEN awareness_level >= 40 AND awareness_level < 50 THEN '40-50%'
            WHEN awareness_level >= 50 AND awareness_level < 60 THEN '50-60%'
            WHEN awareness_level >= 60 AND awareness_level < 70 THEN '60-70%'
            WHEN awareness_level >= 70 AND awareness_level < 80 THEN '70-80%'
            WHEN awareness_level >= 80 AND awareness_level < 90 THEN '80-90%'
            WHEN awareness_level >= 90 THEN '90-100%'
        END as level_range,
        COUNT(*) as count
    FROM cycles
    GROUP BY level_range
    ORDER BY level_range
");

// رشد کاربران (30 روز اخیر)
$userGrowth = $db->fetchAll("
    SELECT
        DATE(created_at) as date,
        COUNT(*) as count
    FROM users
    WHERE DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)
    GROUP BY DATE(created_at)
    ORDER BY date ASC
");

// توزیع جنسیتی
$genderDistribution = $db->fetchAll("
    SELECT
        gender,
        COUNT(*) as count
    FROM users
    WHERE gender IS NOT NULL AND gender != ''
    GROUP BY gender
");

// توزیع سنی
$ageDistribution = $db->fetchAll("
    SELECT
        CASE
            WHEN age < 18 THEN 'زیر 18'
            WHEN age BETWEEN 18 AND 24 THEN '18-24'
            WHEN age BETWEEN 25 AND 34 THEN '25-34'
            WHEN age BETWEEN 35 AND 44 THEN '35-44'
            WHEN age BETWEEN 45 AND 54 THEN '45-54'
            WHEN age >= 55 THEN '55+'
            ELSE 'نامشخص'
        END as age_range,
        COUNT(*) as count
    FROM users
    WHERE age IS NOT NULL
    GROUP BY age_range
    ORDER BY
        CASE age_range
            WHEN 'زیر 18' THEN 1
            WHEN '18-24' THEN 2
            WHEN '25-34' THEN 3
            WHEN '35-44' THEN 4
            WHEN '45-54' THEN 5
            WHEN '55+' THEN 6
            ELSE 7
        END
");

// فعال‌ترین کاربران
$topUsers = $db->fetchAll("
    SELECT
        u.id,
        u.email,
        u.full_name,
        u.total_cycles,
        s.plan_type
    FROM users u
    LEFT JOIN subscriptions s ON u.id = s.user_id AND s.status = 'active'
    ORDER BY u.total_cycles DESC
    LIMIT 10
");

include 'php/includes/header.php';
?>


<!-- فیلتر بازه زمانی -->
<div class="row clearfix">
    <div class="col-lg-12">
        <div class="card">
            <div class="body">
                <form method="GET" action="" class="form-inline">
                    <div class="form-group">
                        <label class="m-l-10 m-r-10">بازه زمانی:</label>
                        <input type="date" name="date_from" class="form-control" value="<?php echo h($dateFrom); ?>">
                    </div>

                    <div class="form-group">
                        <label class="m-l-10 m-r-10">تا:</label>
                        <input type="date" name="date_to" class="form-control" value="<?php echo h($dateTo); ?>">
                    </div>

                    <button type="submit" class="btn-action waves-effect">
                        <i class="material-icons">search</i>
                        <span>اعمال فیلتر</span>
                    </button>

                    <a href="reports.php" class="btn-action waves-effect">
                        <i class="material-icons">refresh</i>
                        <span>بازنشانی</span>
                    </a>

                    <button type="button" class="btn-action btn-save waves-effect" onclick="exportReport()">
                        <i class="material-icons">file_download</i>
                        <span>خروجی Excel</span>
                    </button>

                    <button type="button" class="btn-action btn-save waves-effect" onclick="exportPDF()">
                        <i class="material-icons">picture_as_pdf</i>
                        <span>خروجی PDF</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- عنوان بخش کاربران -->
<div class="row clearfix">
    <div class="col-lg-12">
        <h3 class="m-t-20 m-b-10"><i class="material-icons" style="vertical-align: middle;">people</i> آمار کاربران</h3>
    </div>
</div>

<!-- آمار کلی کاربران -->
<div class="row clearfix">
    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box bg-cyan hover-expand-effect">
            <div class="icon">
                <i class="material-icons">people</i>
            </div>
            <div class="content">
                <div class="text">کل کاربران</div>
                <div class="number"><?php echo number_format($userStats['total']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box bg-green hover-expand-effect">
            <div class="icon">
                <i class="material-icons">check_circle</i>
            </div>
            <div class="content">
                <div class="text">کاربران فعال</div>
                <div class="number"><?php echo number_format($userStats['active']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box bg-orange hover-expand-effect">
            <div class="icon">
                <i class="material-icons">person_add</i>
            </div>
            <div class="content">
                <div class="text">عضویت این ماه</div>
                <div class="number"><?php echo number_format($userStats['new_this_month']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box bg-red hover-expand-effect">
            <div class="icon">
                <i class="material-icons">block</i>
            </div>
            <div class="content">
                <div class="text">کاربران مسدود</div>
                <div class="number"><?php echo number_format($userStats['banned']); ?></div>
            </div>
        </div>
    </div>
</div>

<!-- عنوان بخش چرخه‌ها -->
<div class="row clearfix">
    <div class="col-lg-12">
        <h3 class="m-t-30 m-b-10"><i class="material-icons" style="vertical-align: middle;">loop</i> آمار چرخه‌ها</h3>
    </div>
</div>

<!-- آمار چرخه‌ها -->
<div class="row clearfix">
    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box-3 bg-purple hover-expand-effect">
            <div class="icon">
                <i class="material-icons">loop</i>
            </div>
            <div class="content">
                <div class="text">کل چرخه‌ها</div>
                <div class="number"><?php echo number_format($cycleStats['total']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box-3 bg-light-blue hover-expand-effect">
            <div class="icon">
                <i class="material-icons">today</i>
            </div>
            <div class="content">
                <div class="text">چرخه‌های امروز</div>
                <div class="number"><?php echo number_format($cycleStats['today']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box-3 bg-teal hover-expand-effect">
            <div class="icon">
                <i class="material-icons">calendar_today</i>
            </div>
            <div class="content">
                <div class="text">چرخه‌های این ماه</div>
                <div class="number"><?php echo number_format($cycleStats['this_month']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box-3 bg-indigo hover-expand-effect">
            <div class="icon">
                <i class="material-icons">trending_up</i>
            </div>
            <div class="content">
                <div class="text">میانگین هر کاربر</div>
                <div class="number"><?php echo number_format($cycleStats['avg_per_user'], 1); ?></div>
            </div>
        </div>
    </div>
</div>

<div class="row clearfix">
    <!-- آمار اشتراک‌ها -->
    <div class="col-lg-6 col-md-6 col-sm-12">
        <div class="card">
            <div class="header">
                <h2>آمار اشتراک‌ها به تفکیک پلن</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>نوع پلن</th>
                                <th>کل اشتراک‌ها</th>
                                <th>فعال</th>
                                <th>درصد</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $totalSubs = array_sum(array_column($subscriptionStats, 'count'));
                            foreach ($subscriptionStats as $stat):
                                $percentage = $totalSubs > 0 ? round(($stat['count'] / $totalSubs) * 100, 1) : 0;
                            ?>
                            <tr>
                                <td><?php echo getPlanBadge($stat['plan_type']); ?></td>
                                <td><?php echo number_format($stat['count']); ?></td>
                                <td><?php echo number_format($stat['active_count']); ?></td>
                                <td>
                                    <div class="progress m-b-0" style="height: 20px;">
                                        <div class="progress-bar bg-cyan" role="progressbar"
                                             style="width: <?php echo $percentage; ?>%"
                                             aria-valuenow="<?php echo $percentage; ?>"
                                             aria-valuemin="0" aria-valuemax="100">
                                            <?php echo $percentage; ?>%
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- توزیع جنسیتی -->
    <div class="col-lg-6 col-md-6 col-sm-12">
        <div class="card">
            <div class="header">
                <h2>توزیع جنسیتی کاربران</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>جنسیت</th>
                                <th>تعداد</th>
                                <th>درصد</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $totalGender = array_sum(array_column($genderDistribution, 'count'));
                            foreach ($genderDistribution as $stat):
                                $percentage = $totalGender > 0 ? round(($stat['count'] / $totalGender) * 100, 1) : 0;
                            ?>
                            <tr>
                                <td><?php echo getGenderLabel($stat['gender']); ?></td>
                                <td><?php echo number_format($stat['count']); ?></td>
                                <td>
                                    <div class="progress m-b-0" style="height: 20px;">
                                        <div class="progress-bar bg-pink" role="progressbar"
                                             style="width: <?php echo $percentage; ?>%"
                                             aria-valuenow="<?php echo $percentage; ?>"
                                             aria-valuemin="0" aria-valuemax="100">
                                            <?php echo $percentage; ?>%
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row clearfix">
    <!-- توزیع سنی -->
    <div class="col-lg-6 col-md-6 col-sm-12">
        <div class="card">
            <div class="header">
                <h2>توزیع سنی کاربران</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>بازه سنی</th>
                                <th>تعداد</th>
                                <th>نمودار</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $totalAge = array_sum(array_column($ageDistribution, 'count'));
                            foreach ($ageDistribution as $stat):
                                $percentage = $totalAge > 0 ? round(($stat['count'] / $totalAge) * 100, 1) : 0;
                            ?>
                            <tr>
                                <td><?php echo h($stat['age_range']); ?></td>
                                <td><?php echo number_format($stat['count']); ?></td>
                                <td>
                                    <div class="progress m-b-0" style="height: 20px;">
                                        <div class="progress-bar bg-teal" role="progressbar"
                                             style="width: <?php echo $percentage; ?>%">
                                            <?php echo $percentage; ?>%
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- فعال‌ترین کاربران -->
    <div class="col-lg-6 col-md-6 col-sm-12">
        <div class="card">
            <div class="header">
                <h2>فعال‌ترین کاربران (براساس تعداد چرخه)</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>کاربر</th>
                                <th>پلن</th>
                                <th>تعداد چرخه</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($topUsers as $user): ?>
                            <tr>
                                <td>
                                    <a href="user_detail.php?id=<?php echo $user['id']; ?>">
                                        <?php echo h($user['full_name'] ?? $user['email']); ?>
                                    </a>
                                </td>
                                <td>
                                    <?php echo $user['plan_type'] ? getPlanBadge($user['plan_type']) : '-'; ?>
                                </td>
                                <td>
                                    <strong><?php echo number_format($user['total_cycles']); ?></strong>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- نمودارها -->
<div class="row clearfix">
    <!-- نمودار چرخه‌ها به تفکیک احساس -->
    <div class="col-lg-6">
        <div class="card">
            <div class="header">
                <h2>چرخه‌ها به تفکیک احساس</h2>
            </div>
            <div class="body">
                <canvas id="cyclesByFeelingChart" height="200"></canvas>
            </div>
        </div>
    </div>

    <!-- نمودار سطح آگاهی -->
    <div class="col-lg-6">
        <div class="card">
            <div class="header">
                <h2>توزیع سطح آگاهی</h2>
            </div>
            <div class="body">
                <canvas id="awarenessLevelChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- نمودار رشد کاربران -->
<div class="row clearfix">
    <div class="col-lg-12">
        <div class="card">
            <div class="header">
                <h2>نمودار رشد کاربران (30 روز اخیر)</h2>
            </div>
            <div class="body">
                <canvas id="userGrowthChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<script src="plugins/chartjs/Chart.bundle.js"></script>
<script>
// نمودار چرخه‌ها به تفکیک احساس (میله‌ای)
const cyclesByFeelingData = {
    labels: [
        <?php
        $feelingLabels = [
            'reactive' => 'واکنشی',
            'contracting' => 'منقبض',
            'growth' => 'رشد',
            'ultimate' => 'نهایی'
        ];
        $feelingCounts = [];
        foreach ($cyclesByFeeling as $item) {
            $label = $feelingLabels[$item['feeling_type']] ?? $item['feeling_type'];
            if ($item['feeling_type'] !== 'other') {
                echo '"' . $label . '",';
                $feelingCounts[] = $item['count'];
            }
        }
        ?>
    ],
    datasets: [{
        label: 'تعداد چرخه‌ها',
        data: [<?php echo implode(',', $feelingCounts); ?>],
        backgroundColor: [
            'rgba(255, 99, 132, 0.7)',
            'rgba(255, 159, 64, 0.7)',
            'rgba(75, 192, 192, 0.7)',
            'rgba(54, 162, 235, 0.7)'
        ],
        borderColor: [
            'rgba(255, 99, 132, 1)',
            'rgba(255, 159, 64, 1)',
            'rgba(75, 192, 192, 1)',
            'rgba(54, 162, 235, 1)'
        ],
        borderWidth: 2
    }]
};

const ctxFeeling = document.getElementById('cyclesByFeelingChart').getContext('2d');
new Chart(ctxFeeling, {
    type: 'bar',
    data: cyclesByFeelingData,
    options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        },
        plugins: {
            legend: {
                display: false
            }
        }
    }
});

// نمودار سطح آگاهی (ستونی)
const awarenessLevelData = {
    labels: [<?php
        echo implode(',', array_map(function($row) {
            return '"' . ($row['level_range'] ?? '') . '"';
        }, $awarenessLevels));
    ?>],
    datasets: [{
        label: 'تعداد',
        data: [<?php echo implode(',', array_column($awarenessLevels, 'count')); ?>],
        backgroundColor: 'rgba(153, 102, 255, 0.7)',
        borderColor: 'rgba(153, 102, 255, 1)',
        borderWidth: 2
    }]
};

const ctxAwareness = document.getElementById('awarenessLevelChart').getContext('2d');
new Chart(ctxAwareness, {
    type: 'bar',
    data: awarenessLevelData,
    options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        },
        plugins: {
            legend: {
                display: false
            }
        }
    }
});

// نمودار رشد کاربران
const userGrowthData = {
    labels: [<?php
        echo implode(',', array_map(function($row) {
            return '"' . formatDate($row['date'], 'm/d') . '"';
        }, $userGrowth));
    ?>],
    datasets: [{
        label: 'تعداد کاربران جدید',
        data: [<?php echo implode(',', array_column($userGrowth, 'count')); ?>],
        backgroundColor: 'rgba(0, 188, 212, 0.3)',
        borderColor: 'rgba(0, 188, 212, 1)',
        borderWidth: 2,
        pointBackgroundColor: 'rgba(0, 188, 212, 1)',
        pointBorderColor: '#fff',
        pointHoverBackgroundColor: '#fff',
        pointHoverBorderColor: 'rgba(0, 188, 212, 1)'
    }]
};

const ctx = document.getElementById('userGrowthChart').getContext('2d');
const userGrowthChart = new Chart(ctx, {
    type: 'line',
    data: userGrowthData,
    options: {
        responsive: true,
        maintainAspectRatio: true,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        }
    }
});

function exportReport() {
    // در اینجا می‌توان کد export به Excel را اضافه کرد
    alert('قابلیت خروجی Excel به زودی اضافه می‌شود.');
}

function exportPDF() {
    window.location.href = 'api/export_pdf.php?type=reports';
}
</script>

<?php include 'php/includes/footer.php'; ?>
