<?php
/**
 * فایل مقداردهی اولیه
 * Initialization File
 */

// تعریف ثابت امنیتی
define('AYENEH_ADMIN', true);

// بارگذاری تنظیمات
require_once __DIR__ . '/config.php';

// بارگذاری کلاس‌ها
require_once PHP_PATH . 'db.class.php';
require_once PHP_PATH . 'session.class.php';
require_once PHP_PATH . 'auth.class.php';

// بارگذاری توابع کمکی
require_once PHP_PATH . 'helper.functions.php';

// ایجاد دایرکتوری لاگ در صورت عدم وجود
if (!file_exists(LOG_DIR)) {
    mkdir(LOG_DIR, 0755, true);
}

// ایجاد دایرکتوری آپلود در صورت عدم وجود
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}

// مدیریت خطاها
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    if (!(error_reporting() & $errno)) {
        return false;
    }

    $error = "Error [$errno]: $errstr in $errfile on line $errline";
    log_error($error);

    if (DEBUG_MODE) {
        echo "<div style='background: #f44336; color: white; padding: 15px; margin: 10px; border-radius: 5px;'>";
        echo "<strong>خطا:</strong> $errstr<br>";
        echo "<strong>فایل:</strong> $errfile<br>";
        echo "<strong>خط:</strong> $errline";
        echo "</div>";
    }

    return true;
});

// مدیریت استثناها
set_exception_handler(function($exception) {
    $error = "Exception: " . $exception->getMessage() . " in " . $exception->getFile() . " on line " . $exception->getLine();
    log_error($error);

    if (DEBUG_MODE) {
        echo "<div style='background: #f44336; color: white; padding: 15px; margin: 10px; border-radius: 5px;'>";
        echo "<strong>استثنا:</strong> " . $exception->getMessage() . "<br>";
        echo "<strong>فایل:</strong> " . $exception->getFile() . "<br>";
        echo "<strong>خط:</strong> " . $exception->getLine() . "<br>";
        echo "<pre>" . $exception->getTraceAsString() . "</pre>";
        echo "</div>";
    } else {
        echo "<div style='text-align: center; padding: 50px;'>";
        echo "<h2>خطایی رخ داده است</h2>";
        echo "<p>لطفاً با مدیر سیستم تماس بگیرید.</p>";
        echo "</div>";
    }
});

?>