<?php if (!defined('AYENEH_ADMIN')) die('Access Denied'); ?>
        </div>
    </section>

    <!-- Modal: تغییر رمز عبور -->
    <div class="modal fade" id="changePasswordModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">تغییر رمز عبور</h4>
                </div>
                <div class="modal-body">
                    <form id="changePasswordForm">
                        <div class="form-group">
                            <label>رمز عبور فعلی *</label>
                            <input type="password" name="current_password" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label>رمز عبور جدید *</label>
                            <input type="password" name="new_password" class="form-control" required minlength="8">
                            <small class="help-text">حداقل 8 کاراکتر</small>
                        </div>

                        <div class="form-group">
                            <label>تکرار رمز عبور جدید *</label>
                            <input type="password" name="confirm_password" class="form-control" required>
                        </div>

                        <div id="changePasswordError" class="alert alert-danger" style="display: none;"></div>
                        <div id="changePasswordSuccess" class="alert alert-success" style="display: none;"></div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">انصراف</button>
                    <button type="button" class="btn btn-primary waves-effect" onclick="submitChangePassword()">تغییر رمز</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Jquery Core Js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <!-- Bootstrap Core Js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js"></script>

    <!-- Bootstrap Select Plugin Js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.12.4/js/bootstrap-select.min.js"></script>

    <!-- Slimscroll Plugin Js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jQuery-slimScroll/1.3.8/jquery.slimscroll.min.js"></script>

    <!-- Waves Effect Plugin Js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/node-waves/0.7.6/waves.min.js"></script>

    <!-- Custom Js -->
    <script src="js/admin.js"></script>
    
    <?php if (isset($extraJS)): ?>
        <?= $extraJS ?>
    <?php endif; ?>

    <script src="js/demo.js"></script>

    <script>
        // اطمینان از مخفی شدن loader
        $(window).on('load', function() {
            $('.page-loader-wrapper').fadeOut(500);
        });

        // Fallback: اگر بعد از 2 ثانیه هنوز loader نمایان است، آن را مخفی کن
        setTimeout(function() {
            $('.page-loader-wrapper').fadeOut(500);
        }, 2000);

        // Toggle sidebar
        $('.bars').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();

            var windowWidth = $(window).width();

            if (windowWidth > 1170) {
                // Desktop: toggle ls-closed class
                $('body').toggleClass('ls-closed');
            } else {
                // Mobile: use overlay
                $('body').toggleClass('overlay-open');
                if ($('body').hasClass('overlay-open')) {
                    $('.overlay').fadeIn();
                    $('.sidebar').addClass('open');
                } else {
                    $('.overlay').fadeOut();
                    $('.sidebar').removeClass('open');
                }
            }
        });

        // Close sidebar when clicking overlay
        $('.overlay').on('click', function() {
            $('body').removeClass('overlay-open');
            $('.overlay').fadeOut();
            $('.sidebar').removeClass('open');
        });

        // Open change password modal
        window.openChangePasswordModal = function() {
            $('#changePasswordModal').modal('show');
            $('#changePasswordForm')[0].reset();
            $('#changePasswordError').hide();
            $('#changePasswordSuccess').hide();
        };

        // Submit change password
        window.submitChangePassword = function() {
            var form = $('#changePasswordForm');
            var currentPassword = form.find('[name="current_password"]').val();
            var newPassword = form.find('[name="new_password"]').val();
            var confirmPassword = form.find('[name="confirm_password"]').val();

            // Hide previous messages
            $('#changePasswordError').hide();
            $('#changePasswordSuccess').hide();

            // Validation
            if (!currentPassword || !newPassword || !confirmPassword) {
                $('#changePasswordError').text('لطفاً تمام فیلدها را پر کنید').show();
                return;
            }

            if (newPassword.length < 8) {
                $('#changePasswordError').text('رمز عبور جدید باید حداقل 8 کاراکتر باشد').show();
                return;
            }

            if (newPassword !== confirmPassword) {
                $('#changePasswordError').text('رمز عبور جدید و تکرار آن یکسان نیستند').show();
                return;
            }

            // Send AJAX request
            $.ajax({
                url: 'api/change_password.php',
                method: 'POST',
                data: {
                    current_password: currentPassword,
                    new_password: newPassword,
                    confirm_password: confirmPassword
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $('#changePasswordSuccess').text(response.message).show();
                        setTimeout(function() {
                            $('#changePasswordModal').modal('hide');
                        }, 2000);
                    } else {
                        $('#changePasswordError').text(response.message || 'خطا در تغییر رمز عبور').show();
                    }
                },
                error: function() {
                    $('#changePasswordError').text('خطا در ارتباط با سرور').show();
                }
            });
        };
    </script>
</body>
</html>
