<?php
/**
 * Ayeneh Admin Panel - Configuration File
 *
 * تنظیمات اصلی سیستم
 */

// جلوگیری از دسترسی مستقیم
if (!defined('AYENEH_ADMIN')) {
    define('AYENEH_ADMIN', true);
}

// تنظیمات نمایش خطا (در محیط توسعه true، در production false)
define('DEBUG_MODE', true);
define('LOG_QUERIES', false); // ثبت کوئری‌ها در لاگ
define('LOG_ERRORS', true); // ثبت خطاها در لاگ
define('LOG_DIR', dirname(dirname(__FILE__)) . '/logs/'); // مسیر لاگ‌ها

if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// تنظیمات دیتابیس
define('DB_HOST', 'localhost');
define('DB_NAME', 'ayene');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// تنظیمات برنامه
define('SITE_NAME', 'پنل مدیریت آینه');
define('SITE_URL', 'https://admin.ayeneh.app');
define('API_URL', 'https://api.ayeneh.app');

// مسیرها
define('ROOT_PATH', dirname(dirname(__FILE__)) . '/');
define('PHP_PATH', ROOT_PATH . 'php/');
define('CLASSES_PATH', PHP_PATH . 'classes/');
define('INCLUDES_PATH', PHP_PATH . 'includes/');
define('UPLOADS_PATH', ROOT_PATH . 'uploads/');

// تنظیمات امنیتی
define('SESSION_LIFETIME', 28800); // 8 ساعت
define('PASSWORD_MIN_LENGTH', 8);
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_TIMEOUT', 900); // 15 دقیقه

// تنظیمات Session
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1);
ini_set('session.cookie_samesite', 'Strict');
ini_set('session.gc_maxlifetime', SESSION_LIFETIME);

// تنظیمات Timezone
date_default_timezone_set('Asia/Tehran');

// تنظیمات زبان پیش‌فرض
define('DEFAULT_LANG', 'fa');

// تنظیمات Pagination
define('ITEMS_PER_PAGE', 20);

// تنظیمات آپلود فایل
define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGE_TYPES', ['jpg', 'jpeg', 'png', 'gif']);

// تنظیمات ایمیل (SMTP)
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'noreply@ayeneh.app');
define('SMTP_PASSWORD', '');
define('SMTP_FROM_EMAIL', 'noreply@ayeneh.app');
define('SMTP_FROM_NAME', 'Ayeneh');
define('SMTP_ENCRYPTION', 'tls'); // tls یا ssl

// تنظیمات Push Notification
define('VAPID_PUBLIC_KEY', '');
define('VAPID_PRIVATE_KEY', '');
define('VAPID_SUBJECT', 'mailto:support@ayeneh.app');

// تنظیمات AI
define('AI_ENABLED', true);
define('OPENAI_API_KEY', '');
define('AI_MODEL', 'gpt-4');
define('AI_MAX_TOKENS', 1000);

// تنظیمات پرداخت
define('STRIPE_PUBLIC_KEY', '');
define('STRIPE_SECRET_KEY', '');
define('STRIPE_WEBHOOK_SECRET', '');

define('GOOGLE_PLAY_SERVICE_ACCOUNT', '');

// تنظیمات درگاه پرداخت ایران
define('ZARINPAL_MERCHANT_ID', '');
define('IDPAY_API_KEY', '');

// سطوح دسترسی
define('ROLE_SUPER_ADMIN', 'super_admin');
define('ROLE_ADMIN', 'admin');
define('ROLE_MODERATOR', 'moderator');

// کلیدهای رمزنگاری
define('ENCRYPTION_KEY', 'your-32-character-encryption-key-here'); // باید تصادفی باشد
define('JWT_SECRET', 'your-jwt-secret-key-here'); // باید تصادفی باشد

// تنظیمات Cache
define('CACHE_ENABLED', true);
define('CACHE_LIFETIME', 3600); // 1 ساعت

// تنظیمات Rate Limiting
define('RATE_LIMIT_ENABLED', true);
define('RATE_LIMIT_REQUESTS', 60); // تعداد درخواست
define('RATE_LIMIT_PERIOD', 60); // در چند ثانیه

// Autoload Classes
spl_autoload_register(function ($class) {
    $file = CLASSES_PATH . $class . '.class.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// شروع Session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// بارگذاری Helper Functions
if (file_exists(INCLUDES_PATH . 'functions.php')) {
    require_once INCLUDES_PATH . 'functions.php';
}
