<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مدیریت پکیج‌ها';
$db = Database::getInstance();

// دریافت پکیج‌ها
$packages = $db->query("
    SELECT * FROM packages
    ORDER BY display_order ASC, id ASC
")->fetchAll();

include 'php/includes/header.php';
?>


<div class="row clearfix">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <h2>لیست پکیج‌ها</h2>
                <ul class="header-dropdown m-r--5">
                    <li>
                        <a href="package_create.php" class="btn-action btn-save waves-effect">
                            <i class="material-icons">add</i>
                            <span>افزودن پکیج جدید</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>نام</th>
                                <th>قیمت ماهانه</th>
                                <th>قیمت سالانه</th>
                                <th>محدودیت چرخه</th>
                                <th>وضعیت</th>
                                <th>ترتیب</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($packages as $pkg): ?>
                            <tr>
                                <td><?php echo $pkg['id']; ?></td>
                                <td>
                                    <strong><?php echo h($pkg['display_name_fa']); ?></strong><br>
                                    <small class="text-muted"><?php echo h($pkg['slug']); ?></small>
                                </td>
                                <td><?php echo formatMoney($pkg['price_monthly'], $pkg['currency']); ?></td>
                                <td><?php echo formatMoney($pkg['price_yearly'], $pkg['currency']); ?></td>
                                <td><?php echo $pkg['max_cycles'] == -1 ? 'نامحدود' : number_format($pkg['max_cycles']); ?></td>
                                <td>
                                    <?php if ($pkg['is_active']): ?>
                                        <span class="badge bg-green">فعال</span>
                                    <?php else: ?>
                                        <span class="badge bg-grey">غیرفعال</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $pkg['display_order']; ?></td>
                                <td class="table-actions">
                                    <a href="package_edit.php?id=<?php echo $pkg['id']; ?>" class="btn btn-xs btn-primary">
                                        <i class="material-icons">edit</i> ویرایش
                                    </a>
                                    <a href="api/package_delete.php?id=<?php echo $pkg['id']; ?>" class="btn btn-xs btn-danger btn-delete">
                                        <i class="material-icons">delete</i> حذف
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const deleteButtons = document.querySelectorAll('.btn-delete');

    deleteButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();

            if (confirm('آیا از حذف این پکیج اطمینان دارید؟\nاین عمل قابل بازگشت نیست.')) {
                window.location.href = this.href;
            }
        });
    });
});
</script>

<?php include 'php/includes/footer.php'; ?>
