<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'ایجاد پکیج جدید';
$db = Database::getInstance();

$error = '';
$success = '';

if (isPost()) {
    if (!verifyCSRFToken(post('csrf_token'))) {
        $error = 'توکن امنیتی نامعتبر است';
    } else {
        // دریافت داده‌ها
        $slug = sanitize(post('slug'));
        $display_name_fa = sanitize(post('display_name_fa'));
        $display_name_en = sanitize(post('display_name_en'));
        $description_fa = sanitize(post('description_fa'));
        $description_en = sanitize(post('description_en'));
        $price_monthly = (float)post('price_monthly');
        $price_yearly = (float)post('price_yearly');
        $currency = sanitize(post('currency', 'EUR'));
        $max_cycles = (int)post('max_cycles', -1);
        $is_active = post('is_active') ? 1 : 0;
        $is_recommended = post('is_recommended') ? 1 : 0;
        $display_order = (int)post('display_order', 0);
        $features = post('features', '');

        // اعتبارسنجی
        if (empty($slug) || empty($display_name_fa)) {
            $error = 'نام انگلیسی و نام فارسی الزامی است';
        } else {
            try {
                // بررسی تکراری نبودن slug
                $exists = $db->fetchOne("SELECT id FROM packages WHERE slug = ?", [$slug]);
                if ($exists) {
                    $error = 'این نام انگلیسی قبلاً استفاده شده است';
                } else {
                    // درج پکیج
                    $packageId = $db->insert('packages', [
                        'slug' => $slug,
                        'display_name_fa' => $display_name_fa,
                        'display_name_en' => $display_name_en,
                        'description_fa' => $description_fa,
                        'description_en' => $description_en,
                        'price_monthly' => $price_monthly,
                        'price_yearly' => $price_yearly,
                        'currency' => $currency,
                        'max_cycles' => $max_cycles,
                        'features' => $features,
                        'is_active' => $is_active,
                        'is_recommended' => $is_recommended,
                        'display_order' => $display_order
                    ]);

                    setFlashMessage('success', 'پکیج با موفقیت ایجاد شد');
                    redirect('packages.php');
                }
            } catch (Exception $e) {
                $error = 'خطا در ایجاد پکیج: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generateCSRFToken();
include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <h2>ایجاد پکیج جدید</h2>
            </div>

            <div class="body">
                <?php if ($error): ?>
                <div class="alert alert-danger">
                    <strong>خطا!</strong> <?php echo h($error); ?>
                </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نام انگلیسی (Slug) *</label>
                                <input type="text" name="slug" class="form-control" required
                                       value="<?php echo h(post('slug', '')); ?>"
                                       placeholder="free_trial, freemium, plus, premium">
                                <small class="help-text">فقط حروف انگلیسی، اعداد و خط تیره</small>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نام نمایشی فارسی *</label>
                                <input type="text" name="display_name_fa" class="form-control" required
                                       value="<?php echo h(post('display_name_fa', '')); ?>"
                                       placeholder="آزمایشی رایگان، پلاس، پرمیوم">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نام نمایشی انگلیسی</label>
                                <input type="text" name="display_name_en" class="form-control"
                                       value="<?php echo h(post('display_name_en', '')); ?>"
                                       placeholder="Free Trial, Plus, Premium">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>واحد پول</label>
                                <select name="currency" class="form-control">
                                    <option value="EUR" <?php echo post('currency') === 'EUR' ? 'selected' : ''; ?>>یورو (EUR)</option>
                                    <option value="USD" <?php echo post('currency') === 'USD' ? 'selected' : ''; ?>>دلار (USD)</option>
                                    <option value="IRR" <?php echo post('currency') === 'IRR' ? 'selected' : ''; ?>>تومان (IRR)</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>قیمت ماهانه</label>
                                <input type="number" step="0.01" name="price_monthly" class="form-control"
                                       value="<?php echo h(post('price_monthly', '0')); ?>">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>قیمت سالانه</label>
                                <input type="number" step="0.01" name="price_yearly" class="form-control"
                                       value="<?php echo h(post('price_yearly', '0')); ?>">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>حداکثر تعداد چرخه</label>
                                <input type="number" name="max_cycles" class="form-control"
                                       value="<?php echo h(post('max_cycles', '-1')); ?>">
                                <small class="help-text">-1 برای نامحدود</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>توضیحات فارسی</label>
                                <textarea name="description_fa" class="form-control" rows="4"><?php echo h(post('description_fa', '')); ?></textarea>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>توضیحات انگلیسی</label>
                                <textarea name="description_en" class="form-control" rows="4"><?php echo h(post('description_en', '')); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>ویژگی‌ها (JSON)</label>
                        <textarea name="features" class="form-control" rows="6"><?php echo h(post('features', '')); ?></textarea>
                        <small class="help-text">مثال: {"feature1": "ویژگی اول", "feature2": "ویژگی دوم"}</small>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>ترتیب نمایش</label>
                                <input type="number" name="display_order" class="form-control"
                                       value="<?php echo h(post('display_order', '0')); ?>">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <input type="checkbox" name="is_active" id="is_active" value="1"
                                       <?php echo post('is_active') ? 'checked' : ''; ?>>
                                <label for="is_active">فعال</label>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <input type="checkbox" name="is_recommended" id="is_recommended" value="1"
                                       <?php echo post('is_recommended') ? 'checked' : ''; ?>>
                                <label for="is_recommended">پیشنهادی</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group m-t-20">
                        <button type="submit" class="btn btn-success waves-effect">
                            <i class="material-icons">save</i>
                            ذخیره پکیج
                        </button>
                        <a href="packages.php" class="btn btn-default waves-effect">
                            <i class="material-icons">cancel</i>
                            انصراف
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
