<?php
define('AYENEH_ADMIN', true);
require_once 'php/config.php';
require_once PHP_PATH . 'db.class.php';
require_once PHP_PATH . 'session.class.php';
require_once PHP_PATH . 'auth.class.php';

// بارگذاری توابع کمکی
if (file_exists(INCLUDES_PATH . 'functions.php')) {
    require_once INCLUDES_PATH . 'functions.php';
} else {
    require_once PHP_PATH . 'helper.functions.php';
}

$auth = Auth::getInstance();

// اگر لاگین است، redirect به dashboard
if ($auth->isLoggedIn()) {
    redirect('index.php');
}





// پردازش فرم
$error = '';
if (isPost()) {
    if (!verifyCSRFToken(post('csrf_token'))) {
        $error = 'توکن امنیتی نامعتبر است';
    } else {
        $email = sanitize(post('email'));
        $password = post('password');
        $remember = post('remember') ? true : false;

        if (empty($email) || empty($password)) {
            $error = 'لطفا تمام فیلدها را پر کنید';
        } else {
            $result = $auth->login($email, $password, $remember);
            if ($result['success']) {
                redirect('index.php');
            } else {
                $error = $result['message'];
            }
        }
    }
}

$csrf_token = generateCSRFToken();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود به پنل مدیریت - آینه</title>

    <!-- فونت وزیر -->
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">

    <!-- Material Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">

    <!-- Custom Login CSS -->
    <link href="css/login.css" rel="stylesheet">
</head>
<body class="ayene-login-page">
    <div class="ayene-login-container">
        <!-- بخش لوگو و آینه -->
        <div class="ayene-logo-section">
            <div class="ayene-mirror-frame">
                <img src="images/mirror-logo.svg" alt="آینه">
                <div class="ayene-welcome-text">
                 مدیریت آینه
                </div>
            </div>
          
        </div>

        <!-- فرم لاگین -->
        <div class="ayene-login-card" id="login-form">
            <?php if ($error): ?>
            <div class="ayene-alert ayene-alert-danger">
                <?php echo h($error); ?>
            </div>
            <?php endif; ?>

            <form method="POST" action="">
                <!-- فیلد ایمیل -->
                <div class="ayene-form-group">
                    <h2 class="ayene-form-title">ایمیل</h2>
                    <div class="ayene-input-wrapper">
                        <input
                            type="email"
                            class="ayene-form-input"
                            name="email"
                            placeholder="example@gmail.com"
                            required
                            autofocus
                            value="<?php echo isset($_POST['email']) ? h($_POST['email']) : ''; ?>"
                        >
                    </div>
                </div>

                <!-- فیلد رمز عبور -->
                <div class="ayene-form-group">
                    <h2 class="ayene-form-title">رمز عبور</h2>
                    <div class="ayene-input-wrapper">
                        <input
                            type="password"
                            class="ayene-form-input has-icon"
                            name="password"
                            id="password-input"
                            placeholder="••••••••"
                            required
                        >
                        <button type="button" class="ayene-password-toggle" onclick="togglePassword()">
                            <i class="material-icons" id="password-icon">visibility_off</i>
                        </button>
                    </div>
                  
                </div>

               
                <!-- توکن CSRF -->
                <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">

                <!-- دکمه ورود -->
                <button type="submit" class="ayene-submit-btn">ورود</button>

              

                <!-- متن پایین فرم -->
                <div class="ayene-footer-text">
                  ایجاد شده با <3 توسط VTJ
                </div>
            </form>
        </div>
    </div>

    <script>
        // تابع نمایش/مخفی کردن رمز عبور
        function togglePassword() {
            const passwordInput = document.getElementById('password-input');
            const passwordIcon = document.getElementById('password-icon');

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                passwordIcon.textContent = 'visibility';
            } else {
                passwordInput.type = 'password';
                passwordIcon.textContent = 'visibility_off';
            }
        }

        // Smooth scroll برای دکمه "ورود به آینه"
        document.querySelector('.ayene-enter-link')?.addEventListener('click', function(e) {
            e.preventDefault();
            document.getElementById('login-form').scrollIntoView({
                behavior: 'smooth'
            });
        });
    </script>
</body>
</html>
