<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'داشبورد';

try {
    $db = Database::getInstance();

    // آمار کلی
    $stats = [
        'total_users' => $db->count('users'),
        'active_users' => $db->count('users', 'status = :status', [':status' => 'active']),
        'banned_users' => $db->count('users', 'status = :status', [':status' => 'banned']),
        'total_cycles' => $db->count('cycles'),
        'total_subscriptions' => $db->count('subscriptions', 'status = :status', [':status' => 'active']),
    ];

    // آمار اشتراک‌ها
    $subscription_stats = $db->query("
        SELECT plan_type, COUNT(*) as count
        FROM subscriptions
        WHERE status = 'active'
        GROUP BY plan_type
    ")->fetchAll();

    // آخرین کاربران
    $latest_users = $db->query("
        SELECT id, email, full_name, created_at, status
        FROM users
        ORDER BY created_at DESC
        LIMIT 5
    ")->fetchAll();

    // میانگین سطح آگاهی کاربران
    $avg_awareness_result = $db->query("
        SELECT AVG(awareness_level) as avg_awareness
        FROM cycles
    ")->fetch();
    $avg_awareness = $avg_awareness_result ? round($avg_awareness_result['avg_awareness'] ?? 0, 2) : 0;

    // کاربران فعال امروز/این هفته/این ماه
    $active_users_today = $db->query("
        SELECT COUNT(DISTINCT user_id) as count
        FROM cycles
        WHERE DATE(created_at) = CURDATE()
    ")->fetch()['count'] ?? 0;

    $active_users_week = $db->query("
        SELECT COUNT(DISTINCT user_id) as count
        FROM cycles
        WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
    ")->fetch()['count'] ?? 0;

    $active_users_month = $db->query("
        SELECT COUNT(DISTINCT user_id) as count
        FROM cycles
        WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)
    ")->fetch()['count'] ?? 0;
} catch (Exception $e) {
    // در صورت خطا، مقادیر پیش‌فرض را تنظیم کن
    $stats = [
        'total_users' => 0,
        'active_users' => 0,
        'banned_users' => 0,
        'total_cycles' => 0,
        'total_subscriptions' => 0,
    ];
    $subscription_stats = [];
    $latest_users = [];
    $avg_awareness = 0;
    $active_users_today = 0;
    $active_users_week = 0;
    $active_users_month = 0;

    // ثبت خطا در لاگ
    if (DEBUG_MODE) {
        error_log("Dashboard Error: " . $e->getMessage());
    }
}

include 'php/includes/header.php';
?>

<div class="row clearfix">
    <!-- کل کاربران -->
    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
        <div class="info-box bg-pink hover-expand-effect">
            <div class="icon">
                <i class="material-icons">people</i>
            </div>
            <div class="content">
                <div class="text">کل کاربران</div>
                <div class="number count-to" data-from="0" data-to="<?php echo $stats['total_users']; ?>" data-speed="1000" data-fresh-interval="20">
                    <?php echo number_format($stats['total_users']); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- کاربران فعال -->
    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
        <div class="info-box bg-cyan hover-expand-effect">
            <div class="icon">
                <i class="material-icons">person</i>
            </div>
            <div class="content">
                <div class="text">کاربران فعال</div>
                <div class="number count-to" data-from="0" data-to="<?php echo $stats['active_users']; ?>" data-speed="1000" data-fresh-interval="20">
                    <?php echo number_format($stats['active_users']); ?>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="row clearfix">
    <!-- چرخه‌ها -->
    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
        <div class="info-box bg-light-green hover-expand-effect">
            <div class="icon">
                <i class="material-icons">loop</i>
            </div>
            <div class="content">
                <div class="text">کل چرخه‌ها</div>
                <div class="number count-to" data-from="0" data-to="<?php echo $stats['total_cycles']; ?>" data-speed="1000" data-fresh-interval="20">
                    <?php echo number_format($stats['total_cycles']); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- اشتراک‌های فعال -->
    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
        <div class="info-box bg-orange hover-expand-effect">
            <div class="icon">
                <i class="material-icons">payment</i>
            </div>
            <div class="content">
                <div class="text">اشتراک‌های فعال</div>
                <div class="number count-to" data-from="0" data-to="<?php echo $stats['total_subscriptions']; ?>" data-speed="1000" data-fresh-interval="20">
                    <?php echo number_format($stats['total_subscriptions']); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- میانگین سطح آگاهی -->
    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
        <div class="info-box bg-purple hover-expand-effect">
            <div class="icon">
                <i class="material-icons">psychology</i>
            </div>
            <div class="content">
                <div class="text">میانگین سطح آگاهی</div>
                <div class="number count-to" data-from="0" data-to="<?php echo $avg_awareness; ?>" data-speed="1000" data-fresh-interval="20">
                    <?php echo number_format($avg_awareness, 2); ?>%
                </div>
            </div>
        </div>
    </div>
</div>

<!-- کاربران فعال -->
<div class="row clearfix">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <h2>کاربران فعال</h2>
            </div>
            <div class="body">
                <div class="form-group">
                    <label>بازه زمانی:</label>
                    <select class="form-control" id="activeUsersPeriod" onchange="updateActiveUsers()" style="max-width: 300px;">
                        <option value="today">امروز</option>
                        <option value="week">این هفته</option>
                        <option value="month" selected>این ماه</option>
                    </select>
                </div>
                <div class="info-box-3 bg-teal">
                    <div class="icon">
                        <i class="material-icons">people_outline</i>
                    </div>
                    <div class="content">
                        <div class="text">تعداد کاربران فعال</div>
                        <div class="number" id="activeUsersCount"><?php echo number_format($active_users_month); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- آمار اشتراک‌ها -->
<div class="row clearfix">
    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <h2>آمار اشتراک‌ها</h2>
            </div>
            <div class="body">
                <table class="table table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                            <th>نوع پلن</th>
                            <th>تعداد</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($subscription_stats as $stat): ?>
                        <tr>
                            <td><?php echo getPlanBadge($stat['plan_type']); ?></td>
                            <td><?php echo number_format($stat['count']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- آخرین ۵ کاربر -->
    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <h2>آخرین ۵ کاربر ثبت‌نام شده</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ایمیل</th>
                                <th>تاریخ عضویت</th>
                                <th>وضعیت</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($latest_users as $user): ?>
                            <tr>
                                <td>
                                    <a href="user_detail.php?id=<?php echo $user['id']; ?>">
                                        <?php echo h($user['email']); ?>
                                    </a>
                                </td>
                                <td><?php echo timeAgo($user['created_at']); ?></td>
                                <td><?php echo getUserStatusBadge($user['status']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
const activeUsersData = {
    today: <?php echo $active_users_today; ?>,
    week: <?php echo $active_users_week; ?>,
    month: <?php echo $active_users_month; ?>
};

function updateActiveUsers() {
    const period = document.getElementById('activeUsersPeriod').value;
    const count = activeUsersData[period];
    document.getElementById('activeUsersCount').textContent = count.toLocaleString('fa-IR');
}
</script>

<?php include 'php/includes/footer.php'; ?>
