<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مدیریت فیدبک‌ها';
$db = Database::getInstance();

// دریافت لیست فیدبک‌ها
$feedbacks = $db->query("
    SELECT
        f.*,
        u.email,
        u.full_name
    FROM feedbacks f
    LEFT JOIN users u ON f.user_id = u.id
    ORDER BY f.created_at DESC
    LIMIT 100
")->fetchAll();

$total = count($feedbacks);

include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12">
        <div class="card">
            <div class="header">
                <h2>
                    مدیریت فیدبک‌ها
                    <small><?php echo number_format($total); ?> فیدبک</small>
                </h2>
            </div>

            <div class="body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>کاربر</th>
                                <th>موضوع</th>
                                <th>پیام</th>
                                <th>امتیاز</th>
                                <th>وضعیت</th>
                                <th>تاریخ</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($feedbacks as $feedback): ?>
                            <tr>
                                <td><?php echo $feedback['id']; ?></td>
                                <td>
                                    <?php if ($feedback['user_id']): ?>
                                        <a href="user_detail.php?id=<?php echo $feedback['user_id']; ?>">
                                            <?php echo h($feedback['full_name'] ?? $feedback['email']); ?>
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted">ناشناس</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo h($feedback['subject'] ?? '-'); ?></td>
                                <td>
                                    <?php
                                    $message = $feedback['message'] ?? '';
                                    echo h(mb_substr($message, 0, 50)) . (mb_strlen($message) > 50 ? '...' : '');
                                    ?>
                                </td>
                                <td>
                                    <?php if ($feedback['rating']): ?>
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <i class="material-icons" style="font-size: 16px; color: <?php echo $i <= $feedback['rating'] ? '#FFD700' : '#ccc'; ?>">star</i>
                                        <?php endfor; ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                    $replied = $feedback['admin_reply'] ? true : false;
                                    ?>
                                    <?php if ($replied): ?>
                                        <span class="badge bg-green">پاسخ داده شده</span>
                                    <?php else: ?>
                                        <span class="badge bg-orange">در انتظار پاسخ</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo formatDate($feedback['created_at']); ?></td>
                                <td class="table-actions">
                                    <a href="feedback_detail.php?id=<?php echo $feedback['id']; ?>" class="btn btn-xs btn-info" title="مشاهده و پاسخ">
                                        <i class="material-icons">reply</i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($feedbacks)): ?>
                            <tr>
                                <td colspan="8" class="text-center">هیچ فیدبکی یافت نشد</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
