<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'ایجاد کد تخفیف جدید';
$db = Database::getInstance();

$error = '';
$success = '';

if (isPost()) {
    if (!verifyCSRFToken(post('csrf_token'))) {
        $error = 'توکن امنیتی نامعتبر است';
    } else {
        // دریافت داده‌ها
        $code = strtoupper(sanitize(post('code')));
        $discount_type = sanitize(post('discount_type'));
        $discount_value = (float)post('discount_value');
        $plan_type = sanitize(post('plan_type', ''));
        $max_uses = (int)post('max_uses', 0);
        $expires_at = post('expires_at');
        $is_active = post('is_active') ? 1 : 0;

        // اعتبارسنجی
        if (empty($code)) {
            $error = 'کد تخفیف الزامی است';
        } elseif (!in_array($discount_type, ['percentage', 'fixed'])) {
            $error = 'نوع تخفیف نامعتبر است';
        } elseif ($discount_value <= 0) {
            $error = 'مقدار تخفیف باید بزرگتر از صفر باشد';
        } elseif ($discount_type === 'percentage' && $discount_value > 100) {
            $error = 'درصد تخفیف نمی‌تواند بیشتر از 100 باشد';
        } else {
            try {
                // بررسی تکراری نبودن کد
                $exists = $db->fetchOne("SELECT id FROM discount_codes WHERE code = ?", [$code]);
                if ($exists) {
                    $error = 'این کد تخفیف قبلاً استفاده شده است';
                } else {
                    // تبدیل plan_type خالی به null
                    if (empty($plan_type)) {
                        $plan_type = null;
                    }

                    // تبدیل تاریخ انقضا
                    if (empty($expires_at)) {
                        $expires_at = null;
                    }

                    // درج کد تخفیف
                    $codeId = $db->insert('discount_codes', [
                        'code' => $code,
                        'discount_type' => $discount_type,
                        'discount_value' => $discount_value,
                        'plan_type' => $plan_type,
                        'max_uses' => $max_uses,
                        'used_count' => 0,
                        'expires_at' => $expires_at,
                        'is_active' => $is_active,
                        'created_by' => getCurrentAdmin()['id'] ?? null
                    ]);

                    setFlashMessage('success', 'کد تخفیف با موفقیت ایجاد شد');
                    redirect('discount_codes.php');
                }
            } catch (Exception $e) {
                $error = 'خطا در ایجاد کد تخفیف: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generateCSRFToken();
include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <h2>ایجاد کد تخفیف جدید</h2>
            </div>

            <div class="body">
                <?php if ($error): ?>
                <div class="alert alert-danger">
                    <strong>خطا!</strong> <?php echo h($error); ?>
                </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>کد تخفیف *</label>
                                <input type="text" name="code" class="form-control" required
                                       value="<?php echo h(post('code', '')); ?>"
                                       placeholder="SUMMER2025"
                                       style="text-transform: uppercase;">
                                <small class="help-text">فقط حروف انگلیسی و اعداد (خودکار به بزرگ تبدیل می‌شود)</small>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نوع تخفیف *</label>
                                <select name="discount_type" class="form-control" required id="discount_type">
                                    <option value="percentage" <?php echo post('discount_type') === 'percentage' ? 'selected' : ''; ?>>درصدی</option>
                                    <option value="fixed" <?php echo post('discount_type') === 'fixed' ? 'selected' : ''; ?>>مبلغ ثابت</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>مقدار تخفیف *</label>
                                <input type="number" step="0.01" name="discount_value" class="form-control" required
                                       value="<?php echo h(post('discount_value', '')); ?>"
                                       placeholder="20" id="discount_value">
                                <small class="help-text" id="discount_help">برای درصدی: 1 تا 100، برای مبلغ ثابت: مبلغ به یورو</small>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>پلن مربوطه</label>
                                <select name="plan_type" class="form-control">
                                    <option value="">همه پلن‌ها</option>
                                    <option value="free_trial" <?php echo post('plan_type') === 'free_trial' ? 'selected' : ''; ?>>آزمایشی رایگان</option>
                                    <option value="freemium" <?php echo post('plan_type') === 'freemium' ? 'selected' : ''; ?>>رایگان</option>
                                    <option value="plus" <?php echo post('plan_type') === 'plus' ? 'selected' : ''; ?>>پلاس</option>
                                    <option value="premium" <?php echo post('plan_type') === 'premium' ? 'selected' : ''; ?>>پرمیوم</option>
                                </select>
                                <small class="help-text">اگر خالی باشد، برای همه پلن‌ها اعمال می‌شود</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>حداکثر تعداد استفاده</label>
                                <input type="number" name="max_uses" class="form-control"
                                       value="<?php echo h(post('max_uses', '0')); ?>"
                                       placeholder="0">
                                <small class="help-text">0 برای نامحدود</small>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاریخ انقضا</label>
                                <input type="datetime-local" name="expires_at" class="form-control"
                                       value="<?php echo h(post('expires_at', '')); ?>">
                                <small class="help-text">اگر خالی باشد، تاریخ انقضا ندارد</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="checkbox" name="is_active" id="is_active" value="1"
                                       <?php echo post('is_active', '1') ? 'checked' : ''; ?>>
                                <label for="is_active">فعال</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group m-t-20">
                        <button type="submit" class="btn btn-success waves-effect">
                            <i class="material-icons">save</i>
                            ذخیره کد تخفیف
                        </button>
                        <a href="discount_codes.php" class="btn btn-default waves-effect">
                            <i class="material-icons">cancel</i>
                            انصراف
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// تغییر راهنما بر اساس نوع تخفیف
document.getElementById('discount_type').addEventListener('change', function() {
    const helpText = document.getElementById('discount_help');
    const valueInput = document.getElementById('discount_value');

    if (this.value === 'percentage') {
        helpText.textContent = 'برای درصدی: 1 تا 100';
        valueInput.setAttribute('max', '100');
        valueInput.setAttribute('min', '1');
    } else {
        helpText.textContent = 'برای مبلغ ثابت: مبلغ به یورو';
        valueInput.removeAttribute('max');
        valueInput.setAttribute('min', '0.01');
    }
});
</script>

<?php include 'php/includes/footer.php'; ?>
