<?php
define('AYENEH_ADMIN', true);
require_once '../php/config.php';

$auth = Auth::getInstance();
$auth->requireRole(ROLE_ADMIN);

$user_id = (int)get('id');

if (!$user_id) {
    setFlashMessage('error', 'شناسه کاربر نامعتبر است');
    redirect('../users.php');
}

$db = Database::getInstance();

// استفاده از Stored Procedure
$db->query("CALL sp_unban_user(:user_id, :admin_id)")
    ->bind(':user_id', $user_id)
    ->bind(':admin_id', $auth->getAdminId())
    ->execute();

setFlashMessage('success', 'مسدودیت کاربر با موفقیت رفع شد');
redirect('../users.php');
