<?php
define('AYENEH_ADMIN', true);
require_once '../php/config.php';

$auth = Auth::getInstance();
$auth->requireRole(ROLE_ADMIN);

if (!isPost()) {
    redirect('../users.php');
}

$user_id = (int)post('user_id');
$reason = sanitize(post('reason'));
$message = sanitize(post('message'));

if (!$user_id || !$reason || !$message) {
    setFlashMessage('error', 'لطفا تمام فیلدها را پر کنید');
    redirect('../users.php');
}

$db = Database::getInstance();

// استفاده از Stored Procedure
$db->query("CALL sp_ban_user(:user_id, :reason, :message, :admin_id)")
    ->bind(':user_id', $user_id)
    ->bind(':reason', $reason)
    ->bind(':message', $message)
    ->bind(':admin_id', $auth->getAdminId())
    ->execute();

setFlashMessage('success', 'کاربر با موفقیت مسدود شد');
redirect('../users.php');
