<?php
define('AYENEH_ADMIN', true);
require_once '../php/config.php';

$auth = Auth::getInstance();
$auth->requireRole(ROLE_ADMIN);

if (!isPost()) {
    errorResponse('متد نامعتبر', 405);
}

$send_type = sanitize(post('send_type'));
$title = sanitize(post('title'));
$body = sanitize(post('body'));
$link = sanitize(post('link', ''));
$user_id = (int)post('user_id', 0);

if (!$title || !$body) {
    errorResponse('عنوان و متن الزامی است');
}

$db = Database::getInstance();

if ($send_type === 'all') {
    // ارسال به همه با Stored Procedure
    $db->query("CALL sp_send_notification_to_all(:title, :body, :link, :admin_id)")
        ->bind(':title', $title)
        ->bind(':body', $body)
        ->bind(':link', $link)
        ->bind(':admin_id', $auth->getAdminId())
        ->execute();
} else {
    // ارسال به یک کاربر
    $notification_id = $db->insert('notifications', [
        'user_id' => $user_id,
        'send_type' => 'single',
        'title' => $title,
        'body' => $body,
        'link' => $link,
        'status' => 'sent',
        'sent_by' => $auth->getAdminId(),
        'sent_at' => date('Y-m-d H:i:s')
    ]);

    // ثبت لاگ
    $db->insert('notification_logs', [
        'notification_id' => $notification_id,
        'user_id' => $user_id,
        'status' => 'sent'
    ]);
}

successResponse([], 'نوتیفیکیشن با موفقیت ارسال شد');
