<?php
define('AYENEH_ADMIN', true);
require_once '../php/autoload.php';

$auth = Auth::getInstance();
$auth->requireRole(ROLE_ADMIN);

$packageId = (int)get('id');

if (!$packageId) {
    setFlashMessage('error', 'شناسه پکیج نامعتبر است');
    redirect('../packages.php');
}

$db = Database::getInstance();

// بررسی وجود پکیج
$package = $db->fetchOne("SELECT * FROM packages WHERE id = ?", [$packageId]);

if (!$package) {
    setFlashMessage('error', 'پکیج یافت نشد');
    redirect('../packages.php');
}

// بررسی اینکه آیا پکیج در حال استفاده است
$usageCount = $db->fetchColumn("SELECT COUNT(*) FROM subscriptions WHERE package_id = ?", [$packageId]);

if ($usageCount > 0) {
    setFlashMessage('error', "این پکیج توسط {$usageCount} اشتراک در حال استفاده است و نمی‌توان آن را حذف کرد");
    redirect('../packages.php');
}

try {
    // حذف پکیج
    $db->delete('packages', 'id = ?', [$packageId]);

    // ثبت لاگ
    $adminData = $auth->getAdmin();
    $auth->logActivity($adminData['id'], 'delete_package', 'package', $packageId, [
        'slug' => $package['slug'],
        'name' => $package['display_name_fa']
    ]);

    setFlashMessage('success', 'پکیج با موفقیت حذف شد');
} catch (Exception $e) {
    setFlashMessage('error', 'خطا در حذف پکیج: ' . $e->getMessage());
}

redirect('../packages.php');
