<?php
define('AYENEH_ADMIN', true);
require_once '../php/config.php';

header('Content-Type: application/json; charset=utf-8');

$auth = Auth::getInstance();

if (!$auth->isLoggedIn()) {
    echo json_encode([
        'success' => false,
        'message' => 'لطفاً ابتدا وارد سیستم شوید'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

if (!isPost()) {
    echo json_encode([
        'success' => false,
        'message' => 'متد نامعتبر'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$currentPassword = post('current_password');
$newPassword = post('new_password');
$confirmPassword = post('confirm_password');

// اعتبارسنجی
if (empty($currentPassword) || empty($newPassword) || empty($confirmPassword)) {
    echo json_encode([
        'success' => false,
        'message' => 'لطفاً تمام فیلدها را پر کنید'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

if (strlen($newPassword) < 8) {
    echo json_encode([
        'success' => false,
        'message' => 'رمز عبور جدید باید حداقل 8 کاراکتر باشد'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

if ($newPassword !== $confirmPassword) {
    echo json_encode([
        'success' => false,
        'message' => 'رمز عبور جدید و تکرار آن یکسان نیستند'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$db = Database::getInstance();
$admin = $auth->getAdmin();

// دریافت اطلاعات کاربر
$user = $db->fetchOne("SELECT * FROM users WHERE id = ?", [$admin['user_id']]);

if (!$user) {
    echo json_encode([
        'success' => false,
        'message' => 'کاربر یافت نشد'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// بررسی رمز عبور فعلی
if (!password_verify($currentPassword, $user['password'])) {
    echo json_encode([
        'success' => false,
        'message' => 'رمز عبور فعلی اشتباه است'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// هش کردن رمز عبور جدید
$hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

// بروزرسانی رمز عبور
try {
    $db->update('users', [
        'password' => $hashedPassword,
        'updated_at' => date('Y-m-d H:i:s')
    ], 'id = ?', [$admin['user_id']]);

    // ثبت لاگ
    $auth->logActivity($admin['id'], 'change_password', 'user', $admin['user_id'], [
        'note' => 'تغییر رمز عبور توسط خود کاربر'
    ]);

    echo json_encode([
        'success' => true,
        'message' => 'رمز عبور با موفقیت تغییر کرد'
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'خطا در تغییر رمز عبور'
    ], JSON_UNESCAPED_UNICODE);
}
